<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Student;
use Inertia\Inertia;

class StudentPortalController extends Controller
{
    public function index()
    {
        return Inertia::render('Student/Login');
    }

    public function login(Request $request)
    {
        $request->validate([
            'email' => 'required|email',
            'state_code' => 'required|string'
        ]);

        $student = Student::where('email', $request->email)
                         ->where('state_code', $request->state_code)
                         ->first();

        if (!$student) {
            return back()->withErrors([
                'email' => 'Invalid email and state code combination.'
            ]);
        }

        return redirect()->route('student.profile', $student->id);
    }

    public function profile($studentId)
    {
        $student = Student::with(['courses' => function($query) {
            $query->withPivot(['payment_status', 'is_certified', 'enrollment_date', 'certification_date', 'certificate_number']);
        }])->findOrFail($studentId);

        return Inertia::render('Student/Profile', [
            'student' => $student
        ]);
    }
}
