<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Student;
use App\Models\StudentCourse;
use App\Models\ManualCertificateRecord;
use Inertia\Inertia;

class VerificationController extends Controller
{
    public function index()
    {
        return Inertia::render('Verification/Index');
    }

    public function verify(Request $request)
    {
        $request->validate([
            'certificate_number' => 'required|string'
        ]);

        // Check regular certificates first
        $studentCourse = StudentCourse::with(['student', 'course'])
                                    ->where('certificate_number', $request->certificate_number)
                                    ->where('is_certified', true)
                                    ->first();

        if ($studentCourse) {
            return Inertia::render('Verification/Result', [
                'certificate' => [
                    'certificate_number' => $studentCourse->certificate_number,
                    'student_name' => $studentCourse->student->name,
                    'state_code' => $studentCourse->student->state_code,
                    'center' => $studentCourse->student->center,
                    'course_name' => $studentCourse->course->name,
                    'certification_date' => $studentCourse->certification_date,
                    'is_manual' => false
                ]
            ]);
        }

        // Check manual certificate records
        $manualCertificate = ManualCertificateRecord::with('center')
                                                  ->where('certificate_number', $request->certificate_number)
                                                  ->first();

        if ($manualCertificate) {
            return Inertia::render('Verification/Result', [
                'certificate' => [
                    'certificate_number' => $manualCertificate->certificate_number,
                    'student_name' => $manualCertificate->student_name,
                    'course_name' => $manualCertificate->course_name,
                    'certification_date' => $manualCertificate->issuance_date,
                    'is_manual' => true
                ]
            ]);
        }

        return back()->withErrors([
            'certificate_number' => 'Invalid certificate number or certificate not found.'
        ]);
    }
}
