<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Concerns\HasUuids;

class Center extends Model
{
    use HasUuids;

    protected $fillable = [
        'name',
        'location',
        'manager_name',
        'contact_email',
        'contact_phone',
        'is_active',
    ];

    protected $casts = [
        'is_active' => 'boolean',
    ];

    public function students()
    {
        return $this->hasMany(Student::class);
    }

    public function courses()
    {
        return $this->hasMany(Course::class);
    }
    
    public function partners()
    {
        return $this->hasMany(Partner::class);
    }
    
    public function manager()
    {
        return $this->hasOne(Partner::class)->where('is_manager', true);
    }
}
