<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Concerns\HasUuids;

class CertificateCredit extends Model
{
    use HasUuids;

    protected $fillable = [
        'credits_purchased',
        'credits_used',
        'credits_remaining',
        'cost_per_credit',
        'total_cost',
        'purchased_by_type',
        'purchased_by_id',
        'purchased_by_name',
        'notes',
    ];

    protected $casts = [
        'cost_per_credit' => 'decimal:2',
        'total_cost' => 'decimal:2',
    ];

    public static function getTotalCreditsRemaining()
    {
        return self::sum('credits_remaining');
    }

    public static function useCredit()
    {
        $credit = self::where('credits_remaining', '>', 0)->oldest()->first();
        
        if ($credit) {
            $credit->credits_used += 1;
            $credit->credits_remaining -= 1;
            $credit->save();
            return true;
        }
        
        return false;
    }
}