<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Concerns\HasUuids;

class Course extends Model
{
    use HasUuids;

    protected $fillable = [
        'name',
        'description',
        'price',
        'duration_months',
        'is_active',
        'center_id',
    ];

    protected $casts = [
        'price' => 'decimal:2',
        'is_active' => 'boolean',
    ];

    public function students()
    {
        return $this->belongsToMany(Student::class, 'student_courses')
                    ->withPivot(['payment_status', 'is_certified', 'enrollment_date', 'certification_date', 'certificate_number'])
                    ->withTimestamps();
    }

    public function studentCourses()
    {
        return $this->hasMany(StudentCourse::class);
    }

    public function center()
    {
        return $this->belongsTo(Center::class);
    }
}
