<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Concerns\HasUuids;

class PaymentRecord extends Model
{
    use HasUuids;

    protected $fillable = [
        'student_course_id',
        'amount',
        'payment_method',
        'notes',
        'recorded_by_type',
        'recorded_by_id',
        'recorded_by_name',
        'payment_date',
    ];

    protected $casts = [
        'payment_date' => 'datetime',
        'amount' => 'decimal:2',
    ];

    public function studentCourse()
    {
        return $this->belongsTo(StudentCourse::class);
    }
}