<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Concerns\HasUuids;

class Student extends Model
{
    use HasUuids;

    protected $fillable = [
        'name',
        'state_code',
        'email',
        'phone',
        'center',
        'center_id',
        'enrollment_date',
        'created_by_type',
        'created_by_id',
        'created_by_name',
    ];

    protected $casts = [
        'enrollment_date' => 'date',
    ];

    public function courses()
    {
        return $this->belongsToMany(Course::class, 'student_courses')
                    ->withPivot(['payment_status', 'is_certified', 'enrollment_date', 'certification_date', 'certificate_number'])
                    ->withTimestamps();
    }

    public function studentCourses()
    {
        return $this->hasMany(StudentCourse::class);
    }

    public function center()
    {
        return $this->belongsTo(Center::class);
    }

    public function activityLogs()
    {
        return $this->hasMany(ActivityLog::class);
    }
}
