<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // This migration will recreate tables with UUIDs
        // Drop and recreate is simpler than converting existing data
        Schema::dropIfExists('student_courses');
        Schema::dropIfExists('students');
        Schema::dropIfExists('courses');
        
        // Recreate with UUIDs
        Schema::create('students', function (Blueprint $table) {
            $table->uuid('id')->primary();
            $table->string('name');
            $table->string('state_code')->unique();
            $table->string('email');
            $table->string('phone');
            $table->string('center');
            $table->date('enrollment_date');
            $table->timestamps();
        });
        
        Schema::create('courses', function (Blueprint $table) {
            $table->uuid('id')->primary();
            $table->string('name')->unique();
            $table->text('description')->nullable();
            $table->decimal('price', 10, 2)->default(0);
            $table->integer('duration_months')->default(6);
            $table->boolean('is_active')->default(true);
            $table->timestamps();
        });
        
        Schema::create('student_courses', function (Blueprint $table) {
            $table->uuid('id')->primary();
            $table->uuid('student_id');
            $table->uuid('course_id');
            $table->enum('payment_status', ['pending', 'paid', 'overdue'])->default('pending');
            $table->boolean('is_certified')->default(false);
            $table->date('enrollment_date');
            $table->date('certification_date')->nullable();
            $table->string('certificate_number')->nullable()->unique();
            $table->timestamps();
            
            $table->foreign('student_id')->references('id')->on('students')->onDelete('cascade');
            $table->foreign('course_id')->references('id')->on('courses')->onDelete('cascade');
            $table->unique(['student_id', 'course_id']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('student_courses');
        Schema::dropIfExists('students');
        Schema::dropIfExists('courses');
    }
};
