<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Add center_id to students table
        Schema::table('students', function (Blueprint $table) {
            $table->uuid('center_id')->nullable()->after('center');
            $table->foreign('center_id')->references('id')->on('centers')->onDelete('set null');
        });

        // Add center_id to courses table
        Schema::table('courses', function (Blueprint $table) {
            $table->uuid('center_id')->nullable()->after('is_active');
            $table->foreign('center_id')->references('id')->on('centers')->onDelete('set null');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('students', function (Blueprint $table) {
            $table->dropForeign(['center_id']);
            $table->dropColumn('center_id');
        });

        Schema::table('courses', function (Blueprint $table) {
            $table->dropForeign(['center_id']);
            $table->dropColumn('center_id');
        });
    }
};
