<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Get centers
        $lagosCenter = \App\Models\Center::where('name', 'Lagos Center')->first();
        $abujaCenter = \App\Models\Center::where('name', 'Abuja Center')->first();
        $phCenter = \App\Models\Center::where('name', 'Port Harcourt Center')->first();

        if ($lagosCenter) {
            \App\Models\Student::where('center', 'like', '%Lagos%')->update(['center_id' => $lagosCenter->id]);
        }
        
        if ($abujaCenter) {
            \App\Models\Student::where('center', 'like', '%Abuja%')->update(['center_id' => $abujaCenter->id]);
        }
        
        if ($phCenter) {
            \App\Models\Student::where('center', 'like', '%Port Harcourt%')->update(['center_id' => $phCenter->id]);
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        \App\Models\Student::update(['center_id' => null]);
    }
};
