<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('students', function (Blueprint $table) {
            $table->string('created_by_type')->nullable(); // 'admin' or 'partner'
            $table->uuid('created_by_id')->nullable(); // ID of admin or partner
            $table->string('created_by_name')->nullable(); // Name for display
        });
    }

    public function down(): void
    {
        Schema::table('students', function (Blueprint $table) {
            $table->dropColumn(['created_by_type', 'created_by_id', 'created_by_name']);
        });
    }
};