<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('payment_records', function (Blueprint $table) {
            $table->uuid('id')->primary();
            $table->uuid('student_course_id');
            $table->decimal('amount', 10, 2);
            $table->string('payment_method')->nullable();
            $table->text('notes')->nullable();
            $table->string('recorded_by_type'); // 'admin' or 'partner'
            $table->uuid('recorded_by_id');
            $table->string('recorded_by_name');
            $table->timestamp('payment_date');
            $table->timestamps();
            
            $table->foreign('student_course_id')->references('id')->on('student_courses')->onDelete('cascade');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('payment_records');
    }
};