<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('student_courses', function (Blueprint $table) {
            $table->decimal('amount_paid', 10, 2)->default(0)->after('payment_status');
            $table->string('issued_by_type')->nullable()->after('certificate_number'); // 'admin' or 'partner'
            $table->uuid('issued_by_id')->nullable()->after('issued_by_type');
            $table->string('issued_by_name')->nullable()->after('issued_by_id');
        });
    }

    public function down(): void
    {
        Schema::table('student_courses', function (Blueprint $table) {
            $table->dropColumn(['amount_paid', 'issued_by_type', 'issued_by_id', 'issued_by_name']);
        });
    }
};