<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\Course;

class CourseSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        Course::create([
            'name' => 'Web Development',
            'description' => 'Learn HTML, CSS, JavaScript, and modern web frameworks',
            'price' => 150000.00,
            'duration_months' => 6,
        ]);

        Course::create([
            'name' => 'Data Science',
            'description' => 'Master data analysis, machine learning, and statistical modeling',
            'price' => 200000.00,
            'duration_months' => 8,
        ]);

        Course::create([
            'name' => 'Mobile App Development',
            'description' => 'Build native and cross-platform mobile applications',
            'price' => 180000.00,
            'duration_months' => 7,
        ]);

        Course::create([
            'name' => 'Digital Marketing',
            'description' => 'Learn SEO, social media marketing, and online advertising',
            'price' => 120000.00,
            'duration_months' => 4,
        ]);

        Course::create([
            'name' => 'Cybersecurity',
            'description' => 'Understand network security, ethical hacking, and risk management',
            'price' => 250000.00,
            'duration_months' => 10,
        ]);
    }
}
