"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key2 of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key2) && key2 !== except)
        __defProp(to, key2, { get: () => from[key2], enumerable: !(desc = __getOwnPropDesc(from, key2)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/index.ts
var index_exports = {};
__export(index_exports, {
  Deferred: () => deferred_default,
  Form: () => form_default,
  Head: () => head_default,
  InfiniteScroll: () => infiniteScroll_default,
  Link: () => link_default,
  WhenVisible: () => whenVisible_default,
  config: () => config,
  createInertiaApp: () => createInertiaApp,
  progress: () => import_core13.progress,
  router: () => import_core13.router,
  useForm: () => useForm,
  usePage: () => usePage,
  usePoll: () => usePoll,
  usePrefetch: () => usePrefetch,
  useRemember: () => useRemember
});
module.exports = __toCommonJS(index_exports);
var import_core12 = require("@inertiajs/core");
var import_core13 = require("@inertiajs/core");

// src/app.ts
var import_core3 = require("@inertiajs/core");
var import_vue2 = require("vue");

// src/remember.ts
var import_core = require("@inertiajs/core");
var import_lodash_es = require("lodash-es");
var remember = {
  created() {
    if (!this.$options.remember) {
      return;
    }
    if (Array.isArray(this.$options.remember)) {
      this.$options.remember = { data: this.$options.remember };
    }
    if (typeof this.$options.remember === "string") {
      this.$options.remember = { data: [this.$options.remember] };
    }
    if (typeof this.$options.remember.data === "string") {
      this.$options.remember = { data: [this.$options.remember.data] };
    }
    const rememberKey = this.$options.remember.key instanceof Function ? this.$options.remember.key.call(this) : this.$options.remember.key;
    const restored = import_core.router.restore(rememberKey);
    const rememberable = this.$options.remember.data.filter((key2) => {
      return !(this[key2] !== null && typeof this[key2] === "object" && this[key2].__rememberable === false);
    });
    const hasCallbacks = (key2) => {
      return this[key2] !== null && typeof this[key2] === "object" && typeof this[key2].__remember === "function" && typeof this[key2].__restore === "function";
    };
    rememberable.forEach((key2) => {
      if (this[key2] !== void 0 && restored !== void 0 && restored[key2] !== void 0) {
        hasCallbacks(key2) ? this[key2].__restore(restored[key2]) : this[key2] = restored[key2];
      }
      this.$watch(
        key2,
        () => {
          import_core.router.remember(
            rememberable.reduce(
              (data, key3) => ({
                ...data,
                [key3]: (0, import_lodash_es.cloneDeep)(hasCallbacks(key3) ? this[key3].__remember() : this[key3])
              }),
              {}
            ),
            rememberKey
          );
        },
        { immediate: true, deep: true }
      );
    });
  }
};
var remember_default = remember;

// src/useForm.ts
var import_core2 = require("@inertiajs/core");
var import_lodash_es2 = require("lodash-es");
var import_vue = require("vue");
function useForm(rememberKeyOrData, maybeData) {
  const rememberKey = typeof rememberKeyOrData === "string" ? rememberKeyOrData : null;
  const data = (typeof rememberKeyOrData === "string" ? maybeData : rememberKeyOrData) ?? {};
  const restored = rememberKey ? import_core2.router.restore(rememberKey) : null;
  let defaults = typeof data === "function" ? (0, import_lodash_es2.cloneDeep)(data()) : (0, import_lodash_es2.cloneDeep)(data);
  let cancelToken = null;
  let recentlySuccessfulTimeoutId;
  let transform = (data2) => data2;
  let defaultsCalledInOnSuccess = false;
  const form = (0, import_vue.reactive)({
    ...restored ? restored.data : (0, import_lodash_es2.cloneDeep)(defaults),
    isDirty: false,
    errors: restored ? restored.errors : {},
    hasErrors: false,
    processing: false,
    progress: null,
    wasSuccessful: false,
    recentlySuccessful: false,
    data() {
      return Object.keys(defaults).reduce((carry, key2) => {
        return (0, import_lodash_es2.set)(carry, key2, (0, import_lodash_es2.get)(this, key2));
      }, {});
    },
    transform(callback) {
      transform = callback;
      return this;
    },
    defaults(fieldOrFields, maybeValue) {
      if (typeof data === "function") {
        throw new Error("You cannot call `defaults()` when using a function to define your form data.");
      }
      defaultsCalledInOnSuccess = true;
      if (typeof fieldOrFields === "undefined") {
        defaults = (0, import_lodash_es2.cloneDeep)(this.data());
        this.isDirty = false;
      } else {
        defaults = typeof fieldOrFields === "string" ? (0, import_lodash_es2.set)((0, import_lodash_es2.cloneDeep)(defaults), fieldOrFields, maybeValue) : Object.assign({}, (0, import_lodash_es2.cloneDeep)(defaults), fieldOrFields);
      }
      return this;
    },
    reset(...fields) {
      const resolvedData = typeof data === "function" ? (0, import_lodash_es2.cloneDeep)(data()) : (0, import_lodash_es2.cloneDeep)(defaults);
      const clonedData = (0, import_lodash_es2.cloneDeep)(resolvedData);
      if (fields.length === 0) {
        defaults = clonedData;
        Object.assign(this, resolvedData);
      } else {
        ;
        fields.filter((key2) => (0, import_lodash_es2.has)(clonedData, key2)).forEach((key2) => {
          (0, import_lodash_es2.set)(defaults, key2, (0, import_lodash_es2.get)(clonedData, key2));
          (0, import_lodash_es2.set)(this, key2, (0, import_lodash_es2.get)(resolvedData, key2));
        });
      }
      return this;
    },
    setError(fieldOrFields, maybeValue) {
      Object.assign(this.errors, typeof fieldOrFields === "string" ? { [fieldOrFields]: maybeValue } : fieldOrFields);
      this.hasErrors = Object.keys(this.errors).length > 0;
      return this;
    },
    clearErrors(...fields) {
      this.errors = Object.keys(this.errors).reduce(
        (carry, field) => ({
          ...carry,
          ...fields.length > 0 && !fields.includes(field) ? { [field]: this.errors[field] } : {}
        }),
        {}
      );
      this.hasErrors = Object.keys(this.errors).length > 0;
      return this;
    },
    resetAndClearErrors(...fields) {
      this.reset(...fields);
      this.clearErrors(...fields);
      return this;
    },
    submit(...args) {
      const objectPassed = args[0] !== null && typeof args[0] === "object";
      const method = objectPassed ? args[0].method : args[0];
      const url = objectPassed ? args[0].url : args[1];
      const options = (objectPassed ? args[1] : args[2]) ?? {};
      defaultsCalledInOnSuccess = false;
      const _options = {
        ...options,
        onCancelToken: (token) => {
          cancelToken = token;
          if (options.onCancelToken) {
            return options.onCancelToken(token);
          }
        },
        onBefore: (visit) => {
          this.wasSuccessful = false;
          this.recentlySuccessful = false;
          clearTimeout(recentlySuccessfulTimeoutId);
          if (options.onBefore) {
            return options.onBefore(visit);
          }
        },
        onStart: (visit) => {
          this.processing = true;
          if (options.onStart) {
            return options.onStart(visit);
          }
        },
        onProgress: (event) => {
          this.progress = event;
          if (options.onProgress) {
            return options.onProgress(event);
          }
        },
        onSuccess: async (page2) => {
          this.processing = false;
          this.progress = null;
          this.clearErrors();
          this.wasSuccessful = true;
          this.recentlySuccessful = true;
          recentlySuccessfulTimeoutId = setTimeout(
            () => this.recentlySuccessful = false,
            config.get("form.recentlySuccessfulDuration")
          );
          const onSuccess = options.onSuccess ? await options.onSuccess(page2) : null;
          if (!defaultsCalledInOnSuccess) {
            defaults = (0, import_lodash_es2.cloneDeep)(this.data());
            this.isDirty = false;
          }
          return onSuccess;
        },
        onError: (errors) => {
          this.processing = false;
          this.progress = null;
          this.clearErrors().setError(errors);
          if (options.onError) {
            return options.onError(errors);
          }
        },
        onCancel: () => {
          this.processing = false;
          this.progress = null;
          if (options.onCancel) {
            return options.onCancel();
          }
        },
        onFinish: (visit) => {
          this.processing = false;
          this.progress = null;
          cancelToken = null;
          if (options.onFinish) {
            return options.onFinish(visit);
          }
        }
      };
      const transformedData = transform(this.data());
      if (method === "delete") {
        import_core2.router.delete(url, { ..._options, data: transformedData });
      } else {
        import_core2.router[method](url, transformedData, _options);
      }
    },
    get(url, options) {
      this.submit("get", url, options);
    },
    post(url, options) {
      this.submit("post", url, options);
    },
    put(url, options) {
      this.submit("put", url, options);
    },
    patch(url, options) {
      this.submit("patch", url, options);
    },
    delete(url, options) {
      this.submit("delete", url, options);
    },
    cancel() {
      if (cancelToken) {
        cancelToken.cancel();
      }
    },
    __rememberable: rememberKey === null,
    __remember() {
      return { data: this.data(), errors: this.errors };
    },
    __restore(restored2) {
      Object.assign(this, restored2.data);
      this.setError(restored2.errors);
    }
  });
  (0, import_vue.watch)(
    form,
    (newValue) => {
      form.isDirty = !(0, import_lodash_es2.isEqual)(form.data(), defaults);
      if (rememberKey) {
        import_core2.router.remember((0, import_lodash_es2.cloneDeep)(newValue.__remember()), rememberKey);
      }
    },
    { immediate: true, deep: true }
  );
  return form;
}

// src/app.ts
var component = (0, import_vue2.ref)(void 0);
var page = (0, import_vue2.ref)();
var layout = (0, import_vue2.shallowRef)(null);
var key = (0, import_vue2.ref)(void 0);
var headManager;
var App = (0, import_vue2.defineComponent)({
  name: "Inertia",
  props: {
    initialPage: {
      type: Object,
      required: true
    },
    initialComponent: {
      type: Object,
      required: false
    },
    resolveComponent: {
      type: Function,
      required: false
    },
    titleCallback: {
      type: Function,
      required: false,
      default: (title) => title
    },
    onHeadUpdate: {
      type: Function,
      required: false,
      default: () => () => {
      }
    }
  },
  setup({ initialPage, initialComponent, resolveComponent, titleCallback, onHeadUpdate }) {
    component.value = initialComponent ? (0, import_vue2.markRaw)(initialComponent) : void 0;
    page.value = initialPage;
    key.value = void 0;
    const isServer = typeof window === "undefined";
    headManager = (0, import_core3.createHeadManager)(isServer, titleCallback || ((title) => title), onHeadUpdate || (() => {
    }));
    if (!isServer) {
      import_core3.router.init({
        initialPage,
        resolveComponent,
        swapComponent: async (options) => {
          component.value = (0, import_vue2.markRaw)(options.component);
          page.value = options.page;
          key.value = options.preserveState ? key.value : Date.now();
        }
      });
      import_core3.router.on("navigate", () => headManager.forceUpdate());
    }
    return () => {
      if (component.value) {
        component.value.inheritAttrs = !!component.value.inheritAttrs;
        const child = (0, import_vue2.h)(component.value, {
          ...page.value.props,
          key: key.value
        });
        if (layout.value) {
          component.value.layout = layout.value;
          layout.value = null;
        }
        if (component.value.layout) {
          if (typeof component.value.layout === "function") {
            return component.value.layout(import_vue2.h, child);
          }
          return (Array.isArray(component.value.layout) ? component.value.layout : [component.value.layout]).concat(child).reverse().reduce((child2, layout2) => {
            layout2.inheritAttrs = !!layout2.inheritAttrs;
            return (0, import_vue2.h)(layout2, { ...page.value.props }, () => child2);
          });
        }
        return child;
      }
    };
  }
});
var app_default = App;
var plugin = {
  install(app) {
    import_core3.router.form = useForm;
    Object.defineProperty(app.config.globalProperties, "$inertia", { get: () => import_core3.router });
    Object.defineProperty(app.config.globalProperties, "$page", { get: () => page.value });
    Object.defineProperty(app.config.globalProperties, "$headManager", { get: () => headManager });
    app.mixin(remember_default);
  }
};
function usePage() {
  return (0, import_vue2.reactive)({
    props: (0, import_vue2.computed)(() => page.value?.props),
    url: (0, import_vue2.computed)(() => page.value?.url),
    component: (0, import_vue2.computed)(() => page.value?.component),
    version: (0, import_vue2.computed)(() => page.value?.version),
    clearHistory: (0, import_vue2.computed)(() => page.value?.clearHistory),
    deferredProps: (0, import_vue2.computed)(() => page.value?.deferredProps),
    mergeProps: (0, import_vue2.computed)(() => page.value?.mergeProps),
    prependProps: (0, import_vue2.computed)(() => page.value?.prependProps),
    deepMergeProps: (0, import_vue2.computed)(() => page.value?.deepMergeProps),
    matchPropsOn: (0, import_vue2.computed)(() => page.value?.matchPropsOn),
    rememberedState: (0, import_vue2.computed)(() => page.value?.rememberedState),
    encryptHistory: (0, import_vue2.computed)(() => page.value?.encryptHistory)
  });
}

// src/createInertiaApp.ts
var import_core4 = require("@inertiajs/core");
var import_vue3 = require("vue");
async function createInertiaApp({
  id = "app",
  resolve,
  setup,
  title,
  progress: progress2 = {},
  page: page2,
  render,
  defaults = {}
}) {
  config.replace(defaults);
  const isServer = typeof window === "undefined";
  const el = isServer ? null : document.getElementById(id);
  const initialPage = page2 || JSON.parse(el?.dataset.page || "{}");
  const resolveComponent = (name) => Promise.resolve(resolve(name)).then((module2) => module2.default || module2);
  let head = [];
  const vueApp = await Promise.all([
    resolveComponent(initialPage.component),
    import_core4.router.decryptHistory().catch(() => {
    })
  ]).then(([initialComponent]) => {
    const props = {
      initialPage,
      initialComponent,
      resolveComponent,
      titleCallback: title
    };
    if (isServer) {
      const ssrSetup = setup;
      return ssrSetup({
        el: null,
        App: app_default,
        props: { ...props, onHeadUpdate: (elements) => head = elements },
        plugin
      });
    }
    const csrSetup = setup;
    return csrSetup({
      el,
      App: app_default,
      props,
      plugin
    });
  });
  if (!isServer && progress2) {
    (0, import_core4.setupProgress)(progress2);
  }
  if (isServer && render) {
    const body = await render(
      (0, import_vue3.createSSRApp)({
        render: () => (0, import_vue3.h)("div", {
          id,
          "data-page": JSON.stringify(initialPage),
          innerHTML: vueApp ? render(vueApp) : ""
        })
      })
    );
    return { head, body };
  }
}

// src/deferred.ts
var import_vue4 = require("vue");
var deferred_default = (0, import_vue4.defineComponent)({
  name: "Deferred",
  props: {
    data: {
      type: [String, Array],
      required: true
    }
  },
  render() {
    const keys = Array.isArray(this.$props.data) ? this.$props.data : [this.$props.data];
    if (!this.$slots.fallback) {
      throw new Error("`<Deferred>` requires a `<template #fallback>` slot");
    }
    return keys.every((key2) => this.$page.props[key2] !== void 0) ? this.$slots.default?.() : this.$slots.fallback();
  }
});

// src/form.ts
var import_core5 = require("@inertiajs/core");
var import_lodash_es3 = require("lodash-es");
var import_vue5 = require("vue");
var noop = () => void 0;
var Form = (0, import_vue5.defineComponent)({
  name: "Form",
  slots: Object,
  props: {
    action: {
      type: [String, Object],
      default: ""
    },
    method: {
      type: String,
      default: "get"
    },
    headers: {
      type: Object,
      default: () => ({})
    },
    queryStringArrayFormat: {
      type: String,
      default: "brackets"
    },
    errorBag: {
      type: [String, null],
      default: null
    },
    showProgress: {
      type: Boolean,
      default: true
    },
    transform: {
      type: Function,
      default: (data) => data
    },
    options: {
      type: Object,
      default: () => ({})
    },
    resetOnError: {
      type: [Boolean, Array],
      default: false
    },
    resetOnSuccess: {
      type: [Boolean, Array],
      default: false
    },
    setDefaultsOnSuccess: {
      type: Boolean,
      default: false
    },
    onCancelToken: {
      type: Function,
      default: noop
    },
    onBefore: {
      type: Function,
      default: noop
    },
    onStart: {
      type: Function,
      default: noop
    },
    onProgress: {
      type: Function,
      default: noop
    },
    onFinish: {
      type: Function,
      default: noop
    },
    onCancel: {
      type: Function,
      default: noop
    },
    onSuccess: {
      type: Function,
      default: noop
    },
    onError: {
      type: Function,
      default: noop
    },
    onSubmitComplete: {
      type: Function,
      default: noop
    },
    disableWhileProcessing: {
      type: Boolean,
      default: false
    },
    invalidateCacheTags: {
      type: [String, Array],
      default: () => []
    }
  },
  setup(props, { slots, attrs, expose }) {
    const form = useForm({});
    const formElement = (0, import_vue5.ref)();
    const method = (0, import_vue5.computed)(
      () => (0, import_core5.isUrlMethodPair)(props.action) ? props.action.method : props.method.toLowerCase()
    );
    const isDirty = (0, import_vue5.ref)(false);
    const defaultData = (0, import_vue5.ref)(new FormData());
    const onFormUpdate = (event) => {
      isDirty.value = event.type === "reset" ? false : !(0, import_lodash_es3.isEqual)(getData(), (0, import_core5.formDataToObject)(defaultData.value));
    };
    const formEvents = ["input", "change", "reset"];
    (0, import_vue5.onMounted)(() => {
      defaultData.value = getFormData();
      formEvents.forEach((e) => formElement.value.addEventListener(e, onFormUpdate));
    });
    (0, import_vue5.onBeforeUnmount)(() => formEvents.forEach((e) => formElement.value?.removeEventListener(e, onFormUpdate)));
    const getFormData = () => new FormData(formElement.value);
    const getData = () => (0, import_core5.formDataToObject)(getFormData());
    const submit = () => {
      const [action, data] = (0, import_core5.mergeDataIntoQueryString)(
        method.value,
        (0, import_core5.isUrlMethodPair)(props.action) ? props.action.url : props.action,
        getData(),
        props.queryStringArrayFormat
      );
      const maybeReset = (resetOption) => {
        if (!resetOption) {
          return;
        }
        if (resetOption === true) {
          reset();
        } else if (resetOption.length > 0) {
          reset(...resetOption);
        }
      };
      const submitOptions = {
        headers: props.headers,
        errorBag: props.errorBag,
        showProgress: props.showProgress,
        invalidateCacheTags: props.invalidateCacheTags,
        onCancelToken: props.onCancelToken,
        onBefore: props.onBefore,
        onStart: props.onStart,
        onProgress: props.onProgress,
        onFinish: props.onFinish,
        onCancel: props.onCancel,
        onSuccess: (...args) => {
          props.onSuccess?.(...args);
          props.onSubmitComplete?.(exposed);
          maybeReset(props.resetOnSuccess);
          if (props.setDefaultsOnSuccess === true) {
            defaults();
          }
        },
        onError: (...args) => {
          props.onError?.(...args);
          maybeReset(props.resetOnError);
        },
        ...props.options
      };
      form.transform(() => props.transform(data)).submit(method.value, action, submitOptions);
    };
    const reset = (...fields) => {
      (0, import_core5.resetFormFields)(formElement.value, defaultData.value, fields);
    };
    const resetAndClearErrors = (...fields) => {
      form.clearErrors(...fields);
      reset(...fields);
    };
    const defaults = () => {
      defaultData.value = getFormData();
      isDirty.value = false;
    };
    const exposed = {
      get errors() {
        return form.errors;
      },
      get hasErrors() {
        return form.hasErrors;
      },
      get processing() {
        return form.processing;
      },
      get progress() {
        return form.progress;
      },
      get wasSuccessful() {
        return form.wasSuccessful;
      },
      get recentlySuccessful() {
        return form.recentlySuccessful;
      },
      clearErrors: (...fields) => form.clearErrors(...fields),
      resetAndClearErrors,
      setError: (fieldOrFields, maybeValue) => form.setError(typeof fieldOrFields === "string" ? { [fieldOrFields]: maybeValue } : fieldOrFields),
      get isDirty() {
        return isDirty.value;
      },
      reset,
      submit,
      defaults,
      getData,
      getFormData
    };
    expose(exposed);
    return () => {
      return (0, import_vue5.h)(
        "form",
        {
          ...attrs,
          ref: formElement,
          action: (0, import_core5.isUrlMethodPair)(props.action) ? props.action.url : props.action,
          method: method.value,
          onSubmit: (event) => {
            event.preventDefault();
            submit();
          },
          inert: props.disableWhileProcessing && form.processing
        },
        slots.default ? slots.default(exposed) : []
      );
    };
  }
});
var form_default = Form;

// src/head.ts
var import_lodash_es4 = require("lodash-es");
var import_vue6 = require("vue");
var Head = (0, import_vue6.defineComponent)({
  props: {
    title: {
      type: String,
      required: false
    }
  },
  data() {
    return {
      provider: this.$headManager.createProvider()
    };
  },
  beforeUnmount() {
    this.provider.disconnect();
  },
  methods: {
    isUnaryTag(node) {
      return typeof node.type === "string" && [
        "area",
        "base",
        "br",
        "col",
        "embed",
        "hr",
        "img",
        "input",
        "keygen",
        "link",
        "meta",
        "param",
        "source",
        "track",
        "wbr"
      ].indexOf(node.type) > -1;
    },
    renderTagStart(node) {
      node.props = node.props || {};
      node.props[this.provider.preferredAttribute()] = node.props["head-key"] !== void 0 ? node.props["head-key"] : "";
      const attrs = Object.keys(node.props).reduce((carry, name) => {
        const value = String(node.props[name]);
        if (["key", "head-key"].includes(name)) {
          return carry;
        } else if (value === "") {
          return carry + ` ${name}`;
        } else {
          return carry + ` ${name}="${(0, import_lodash_es4.escape)(value)}"`;
        }
      }, "");
      return `<${String(node.type)}${attrs}>`;
    },
    renderTagChildren(node) {
      const { children } = node;
      if (typeof children === "string") {
        return children;
      }
      if (Array.isArray(children)) {
        return children.reduce((html, child) => {
          return html + this.renderTag(child);
        }, "");
      }
      return "";
    },
    isFunctionNode(node) {
      return typeof node.type === "function";
    },
    isComponentNode(node) {
      return typeof node.type === "object";
    },
    isCommentNode(node) {
      return /(comment|cmt)/i.test(node.type.toString());
    },
    isFragmentNode(node) {
      return /(fragment|fgt|symbol\(\))/i.test(node.type.toString());
    },
    isTextNode(node) {
      return /(text|txt)/i.test(node.type.toString());
    },
    renderTag(node) {
      if (this.isTextNode(node)) {
        return String(node.children);
      } else if (this.isFragmentNode(node)) {
        return "";
      } else if (this.isCommentNode(node)) {
        return "";
      }
      let html = this.renderTagStart(node);
      if (node.children) {
        html += this.renderTagChildren(node);
      }
      if (!this.isUnaryTag(node)) {
        html += `</${String(node.type)}>`;
      }
      return html;
    },
    addTitleElement(elements) {
      if (this.title && !elements.find((tag) => tag.startsWith("<title"))) {
        elements.push(`<title ${this.provider.preferredAttribute()}>${this.title}</title>`);
      }
      return elements;
    },
    renderNodes(nodes) {
      const elements = nodes.flatMap((node) => this.resolveNode(node)).map((node) => this.renderTag(node)).filter((node) => node);
      return this.addTitleElement(elements);
    },
    resolveNode(node) {
      if (this.isFunctionNode(node)) {
        return this.resolveNode(node.type());
      } else if (this.isComponentNode(node)) {
        console.warn(`Using components in the <Head> component is not supported.`);
        return [];
      } else if (this.isTextNode(node) && node.children) {
        return node;
      } else if (this.isFragmentNode(node) && node.children) {
        return node.children.flatMap((child) => this.resolveNode(child));
      } else if (this.isCommentNode(node)) {
        return [];
      } else {
        return node;
      }
    }
  },
  render() {
    this.provider.update(this.renderNodes(this.$slots.default ? this.$slots.default() : []));
  }
});
var head_default = Head;

// src/infiniteScroll.ts
var import_core6 = require("@inertiajs/core");
var import_vue7 = require("vue");
var resolveHTMLElement = (value, fallback) => {
  if (!value) {
    return fallback;
  }
  if (typeof value === "string") {
    return document.querySelector(value);
  }
  if (typeof value === "function") {
    return value() || null;
  }
  return fallback;
};
var InfiniteScroll = (0, import_vue7.defineComponent)({
  name: "InfiniteScroll",
  slots: Object,
  props: {
    data: {
      type: String,
      required: true
    },
    buffer: {
      type: Number,
      default: 0
    },
    onlyNext: {
      type: Boolean,
      default: false
    },
    onlyPrevious: {
      type: Boolean,
      default: false
    },
    as: {
      type: String,
      default: "div"
    },
    manual: {
      type: Boolean,
      default: false
    },
    manualAfter: {
      type: Number,
      default: 0
    },
    preserveUrl: {
      type: Boolean,
      default: false
    },
    reverse: {
      type: Boolean,
      default: false
    },
    autoScroll: {
      type: Boolean,
      default: void 0
    },
    itemsElement: {
      type: [String, Function, Object],
      default: null
    },
    startElement: {
      type: [String, Function, Object],
      default: null
    },
    endElement: {
      type: [String, Function, Object],
      default: null
    }
  },
  inheritAttrs: false,
  setup(props, { slots, attrs, expose }) {
    const itemsElementRef = (0, import_vue7.ref)(null);
    const startElementRef = (0, import_vue7.ref)(null);
    const endElementRef = (0, import_vue7.ref)(null);
    const itemsElement = (0, import_vue7.computed)(
      () => resolveHTMLElement(props.itemsElement, itemsElementRef.value)
    );
    const scrollableParent = (0, import_vue7.computed)(() => (0, import_core6.getScrollableParent)(itemsElement.value));
    const startElement = (0, import_vue7.computed)(
      () => resolveHTMLElement(props.startElement, startElementRef.value)
    );
    const endElement = (0, import_vue7.computed)(() => resolveHTMLElement(props.endElement, endElementRef.value));
    const loadingPrevious = (0, import_vue7.ref)(false);
    const loadingNext = (0, import_vue7.ref)(false);
    const requestCount = (0, import_vue7.ref)(0);
    const {
      dataManager,
      elementManager,
      flush: flushInfiniteScroll
    } = (0, import_core6.useInfiniteScroll)({
      // Data
      getPropName: () => props.data,
      inReverseMode: () => props.reverse,
      shouldFetchNext: () => !props.onlyPrevious,
      shouldFetchPrevious: () => !props.onlyNext,
      shouldPreserveUrl: () => props.preserveUrl,
      // Elements
      getTriggerMargin: () => props.buffer,
      getStartElement: () => startElement.value,
      getEndElement: () => endElement.value,
      getItemsElement: () => itemsElement.value,
      getScrollableParent: () => scrollableParent.value,
      // Request callbacks
      onBeforePreviousRequest: () => loadingPrevious.value = true,
      onBeforeNextRequest: () => loadingNext.value = true,
      onCompletePreviousRequest: () => {
        requestCount.value = dataManager.getRequestCount();
        loadingPrevious.value = false;
      },
      onCompleteNextRequest: () => {
        requestCount.value = dataManager.getRequestCount();
        loadingNext.value = false;
      }
    });
    requestCount.value = dataManager.getRequestCount();
    const autoLoad = (0, import_vue7.computed)(() => !manualMode.value);
    const manualMode = (0, import_vue7.computed)(
      () => props.manual || props.manualAfter > 0 && requestCount.value >= props.manualAfter
    );
    const scrollToBottom = () => {
      if (scrollableParent.value) {
        scrollableParent.value.scrollTo({
          top: scrollableParent.value.scrollHeight,
          behavior: "instant"
        });
      } else {
        window.scrollTo({
          top: document.body.scrollHeight,
          behavior: "instant"
        });
      }
    };
    (0, import_vue7.onMounted)(() => {
      elementManager.setupObservers();
      elementManager.processServerLoadedElements(dataManager.getLastLoadedPage());
      const shouldAutoScroll = props.autoScroll !== void 0 ? props.autoScroll : props.reverse;
      if (shouldAutoScroll) {
        scrollToBottom();
      }
      if (autoLoad.value) {
        elementManager.enableTriggers();
      }
    });
    (0, import_vue7.onUnmounted)(flushInfiniteScroll);
    (0, import_vue7.watch)(
      () => [autoLoad.value, props.onlyNext, props.onlyPrevious],
      ([enabled]) => {
        enabled ? elementManager.enableTriggers() : elementManager.disableTriggers();
      }
    );
    expose({
      fetchNext: dataManager.fetchNext,
      fetchPrevious: dataManager.fetchPrevious,
      hasPrevious: dataManager.hasPrevious,
      hasNext: dataManager.hasNext
    });
    return () => {
      const renderElements = [];
      const sharedExposed = {
        loadingPrevious: loadingPrevious.value,
        loadingNext: loadingNext.value,
        hasPrevious: dataManager.hasPrevious(),
        hasNext: dataManager.hasNext()
      };
      if (!props.startElement) {
        const headerAutoMode = autoLoad.value && !props.onlyNext;
        const exposedPrevious = {
          loading: loadingPrevious.value,
          fetch: dataManager.fetchPrevious,
          autoMode: headerAutoMode,
          manualMode: !headerAutoMode,
          hasMore: dataManager.hasPrevious(),
          ...sharedExposed
        };
        renderElements.push(
          (0, import_vue7.h)(
            "div",
            { ref: startElementRef },
            slots.previous ? slots.previous(exposedPrevious) : loadingPrevious.value ? slots.loading?.(exposedPrevious) : void 0
          )
        );
      }
      renderElements.push(
        (0, import_vue7.h)(
          props.as,
          { ...attrs, ref: itemsElementRef },
          slots.default?.({
            loading: loadingPrevious.value || loadingNext.value,
            loadingPrevious: loadingPrevious.value,
            loadingNext: loadingNext.value
          })
        )
      );
      if (!props.endElement) {
        const footerAutoMode = autoLoad.value && !props.onlyPrevious;
        const exposedNext = {
          loading: loadingNext.value,
          fetch: dataManager.fetchNext,
          autoMode: footerAutoMode,
          manualMode: !footerAutoMode,
          hasMore: dataManager.hasNext(),
          ...sharedExposed
        };
        renderElements.push(
          (0, import_vue7.h)(
            "div",
            { ref: endElementRef },
            slots.next ? slots.next(exposedNext) : loadingNext.value ? slots.loading?.(exposedNext) : void 0
          )
        );
      }
      return (0, import_vue7.h)(import_vue7.Fragment, {}, props.reverse ? [...renderElements].reverse() : renderElements);
    };
  }
});
var infiniteScroll_default = InfiniteScroll;

// src/link.ts
var import_core7 = require("@inertiajs/core");
var import_vue8 = require("vue");
var noop2 = () => {
};
var Link = (0, import_vue8.defineComponent)({
  name: "Link",
  props: {
    as: {
      type: [String, Object],
      default: "a"
    },
    data: {
      type: Object,
      default: () => ({})
    },
    href: {
      type: [String, Object],
      default: ""
    },
    method: {
      type: String,
      default: "get"
    },
    replace: {
      type: Boolean,
      default: false
    },
    preserveScroll: {
      type: [Boolean, String, Function],
      default: false
    },
    preserveState: {
      type: [Boolean, String, Function],
      default: null
    },
    preserveUrl: {
      type: Boolean,
      default: false
    },
    only: {
      type: Array,
      default: () => []
    },
    except: {
      type: Array,
      default: () => []
    },
    headers: {
      type: Object,
      default: () => ({})
    },
    queryStringArrayFormat: {
      type: String,
      default: "brackets"
    },
    async: {
      type: Boolean,
      default: false
    },
    prefetch: {
      type: [Boolean, String, Array],
      default: false
    },
    cacheFor: {
      type: [Number, String, Array],
      default: 0
    },
    onStart: {
      type: Function,
      default: noop2
    },
    onProgress: {
      type: Function,
      default: noop2
    },
    onFinish: {
      type: Function,
      default: noop2
    },
    onBefore: {
      type: Function,
      default: noop2
    },
    onCancel: {
      type: Function,
      default: noop2
    },
    onSuccess: {
      type: Function,
      default: noop2
    },
    onError: {
      type: Function,
      default: noop2
    },
    onCancelToken: {
      type: Function,
      default: noop2
    },
    onPrefetching: {
      type: Function,
      default: noop2
    },
    onPrefetched: {
      type: Function,
      default: noop2
    },
    cacheTags: {
      type: [String, Array],
      default: () => []
    },
    viewTransition: {
      type: [Boolean, Object],
      default: false
    }
  },
  setup(props, { slots, attrs }) {
    const inFlightCount = (0, import_vue8.ref)(0);
    const hoverTimeout = (0, import_vue8.ref)();
    const prefetchModes = (0, import_vue8.computed)(() => {
      if (props.prefetch === true) {
        return ["hover"];
      }
      if (props.prefetch === false) {
        return [];
      }
      if (Array.isArray(props.prefetch)) {
        return props.prefetch;
      }
      return [props.prefetch];
    });
    const cacheForValue = (0, import_vue8.computed)(() => {
      if (props.cacheFor !== 0) {
        return props.cacheFor;
      }
      if (prefetchModes.value.length === 1 && prefetchModes.value[0] === "click") {
        return 0;
      }
      return config.get("prefetch.cacheFor");
    });
    (0, import_vue8.onMounted)(() => {
      if (prefetchModes.value.includes("mount")) {
        prefetch();
      }
    });
    (0, import_vue8.onUnmounted)(() => {
      clearTimeout(hoverTimeout.value);
    });
    const method = (0, import_vue8.computed)(
      () => (0, import_core7.isUrlMethodPair)(props.href) ? props.href.method : (props.method ?? "get").toLowerCase()
    );
    const as = (0, import_vue8.computed)(() => {
      if (typeof props.as !== "string" || props.as.toLowerCase() !== "a") {
        return props.as;
      }
      return method.value !== "get" ? "button" : props.as.toLowerCase();
    });
    const mergeDataArray = (0, import_vue8.computed)(
      () => (0, import_core7.mergeDataIntoQueryString)(
        method.value,
        (0, import_core7.isUrlMethodPair)(props.href) ? props.href.url : props.href,
        props.data || {},
        props.queryStringArrayFormat
      )
    );
    const href = (0, import_vue8.computed)(() => mergeDataArray.value[0]);
    const data = (0, import_vue8.computed)(() => mergeDataArray.value[1]);
    const elProps = (0, import_vue8.computed)(() => {
      if (as.value === "button") {
        return { type: "button" };
      }
      if (as.value === "a" || typeof as.value !== "string") {
        return { href: href.value };
      }
      return {};
    });
    const baseParams = (0, import_vue8.computed)(() => ({
      data: data.value,
      method: method.value,
      replace: props.replace,
      preserveScroll: props.preserveScroll,
      preserveState: props.preserveState ?? method.value !== "get",
      preserveUrl: props.preserveUrl,
      only: props.only,
      except: props.except,
      headers: props.headers,
      async: props.async
    }));
    const visitParams = (0, import_vue8.computed)(() => ({
      ...baseParams.value,
      viewTransition: props.viewTransition,
      onCancelToken: props.onCancelToken,
      onBefore: props.onBefore,
      onStart: (visit) => {
        inFlightCount.value++;
        props.onStart?.(visit);
      },
      onProgress: props.onProgress,
      onFinish: (visit) => {
        inFlightCount.value--;
        props.onFinish?.(visit);
      },
      onCancel: props.onCancel,
      onSuccess: props.onSuccess,
      onError: props.onError
    }));
    const prefetch = () => {
      import_core7.router.prefetch(
        href.value,
        {
          ...baseParams.value,
          onPrefetching: props.onPrefetching,
          onPrefetched: props.onPrefetched
        },
        {
          cacheFor: cacheForValue.value,
          cacheTags: props.cacheTags
        }
      );
    };
    const regularEvents = {
      onClick: (event) => {
        if ((0, import_core7.shouldIntercept)(event)) {
          event.preventDefault();
          import_core7.router.visit(href.value, visitParams.value);
        }
      }
    };
    const prefetchHoverEvents = {
      onMouseenter: () => {
        hoverTimeout.value = setTimeout(() => {
          prefetch();
        }, 75);
      },
      onMouseleave: () => {
        clearTimeout(hoverTimeout.value);
      },
      onClick: regularEvents.onClick
    };
    const prefetchClickEvents = {
      onMousedown: (event) => {
        if ((0, import_core7.shouldIntercept)(event)) {
          event.preventDefault();
          prefetch();
        }
      },
      onKeydown: (event) => {
        if ((0, import_core7.shouldNavigate)(event)) {
          event.preventDefault();
          prefetch();
        }
      },
      onMouseup: (event) => {
        event.preventDefault();
        import_core7.router.visit(href.value, visitParams.value);
      },
      onKeyup: (event) => {
        if ((0, import_core7.shouldNavigate)(event)) {
          event.preventDefault();
          import_core7.router.visit(href.value, visitParams.value);
        }
      },
      onClick: (event) => {
        if ((0, import_core7.shouldIntercept)(event)) {
          event.preventDefault();
        }
      }
    };
    return () => {
      return (0, import_vue8.h)(
        as.value,
        {
          ...attrs,
          ...elProps.value,
          "data-loading": inFlightCount.value > 0 ? "" : void 0,
          ...(() => {
            if (prefetchModes.value.includes("hover")) {
              return prefetchHoverEvents;
            }
            if (prefetchModes.value.includes("click")) {
              return prefetchClickEvents;
            }
            return regularEvents;
          })()
        },
        slots
      );
    };
  }
});
var link_default = Link;

// src/usePoll.ts
var import_core8 = require("@inertiajs/core");
var import_vue9 = require("vue");
function usePoll(interval, requestOptions = {}, options = {
  keepAlive: false,
  autoStart: true
}) {
  const { stop, start } = import_core8.router.poll(interval, requestOptions, {
    ...options,
    autoStart: false
  });
  (0, import_vue9.onMounted)(() => {
    if (options.autoStart ?? true) {
      start();
    }
  });
  (0, import_vue9.onUnmounted)(() => {
    stop();
  });
  return {
    stop,
    start
  };
}

// src/usePrefetch.ts
var import_core9 = require("@inertiajs/core");
var import_vue10 = require("vue");
function usePrefetch(options = {}) {
  const isPrefetching = (0, import_vue10.ref)(false);
  const lastUpdatedAt = (0, import_vue10.ref)(null);
  const isPrefetched = (0, import_vue10.ref)(false);
  const cached = typeof window === "undefined" ? null : import_core9.router.getCached(window.location.pathname, options);
  const inFlight = typeof window === "undefined" ? null : import_core9.router.getPrefetching(window.location.pathname, options);
  lastUpdatedAt.value = cached?.staleTimestamp || null;
  isPrefetching.value = inFlight !== null;
  isPrefetched.value = cached !== null;
  let onPrefetchedListener;
  let onPrefetchingListener;
  (0, import_vue10.onMounted)(() => {
    onPrefetchingListener = import_core9.router.on("prefetching", (e) => {
      if (e.detail.visit.url.pathname === window.location.pathname) {
        isPrefetching.value = true;
      }
    });
    onPrefetchedListener = import_core9.router.on("prefetched", (e) => {
      if (e.detail.visit.url.pathname === window.location.pathname) {
        isPrefetching.value = false;
        isPrefetched.value = true;
      }
    });
  });
  (0, import_vue10.onUnmounted)(() => {
    onPrefetchedListener();
    onPrefetchingListener();
  });
  return {
    lastUpdatedAt,
    isPrefetching,
    isPrefetched,
    flush: () => import_core9.router.flush(window.location.pathname, options)
  };
}

// src/useRemember.ts
var import_core10 = require("@inertiajs/core");
var import_lodash_es5 = require("lodash-es");
var import_vue11 = require("vue");
function useRemember(data, key2) {
  if (typeof data === "object" && data !== null && data.__rememberable === false) {
    return data;
  }
  const restored = import_core10.router.restore(key2);
  const type = (0, import_vue11.isReactive)(data) ? import_vue11.reactive : import_vue11.ref;
  const hasCallbacks = typeof data.__remember === "function" && typeof data.__restore === "function";
  const remembered = type(restored === void 0 ? data : hasCallbacks ? data.__restore(restored) : restored);
  (0, import_vue11.watch)(
    remembered,
    (newValue) => {
      import_core10.router.remember((0, import_lodash_es5.cloneDeep)(hasCallbacks ? data.__remember() : newValue), key2);
    },
    { immediate: true, deep: true }
  );
  return remembered;
}

// src/whenVisible.ts
var import_core11 = require("@inertiajs/core");
var import_vue12 = require("vue");
var whenVisible_default = (0, import_vue12.defineComponent)({
  name: "WhenVisible",
  props: {
    data: {
      type: [String, Array]
    },
    params: {
      type: Object
    },
    buffer: {
      type: Number,
      default: 0
    },
    as: {
      type: String,
      default: "div"
    },
    always: {
      type: Boolean,
      default: false
    }
  },
  data() {
    return {
      loaded: false,
      fetching: false,
      observer: null
    };
  },
  unmounted() {
    this.observer?.disconnect();
  },
  mounted() {
    this.observer = new IntersectionObserver(
      (entries) => {
        if (!entries[0].isIntersecting) {
          return;
        }
        if (!this.$props.always) {
          this.observer?.disconnect();
        }
        if (this.fetching) {
          return;
        }
        this.fetching = true;
        const reloadParams = this.getReloadParams();
        import_core11.router.reload({
          ...reloadParams,
          onStart: (e) => {
            this.fetching = true;
            reloadParams.onStart?.(e);
          },
          onFinish: (e) => {
            this.loaded = true;
            this.fetching = false;
            reloadParams.onFinish?.(e);
          }
        });
      },
      {
        rootMargin: `${this.$props.buffer}px`
      }
    );
    this.observer.observe(this.$el.nextSibling);
  },
  methods: {
    getReloadParams() {
      if (this.$props.data) {
        return {
          only: Array.isArray(this.$props.data) ? this.$props.data : [this.$props.data]
        };
      }
      if (!this.$props.params) {
        throw new Error("You must provide either a `data` or `params` prop.");
      }
      return this.$props.params;
    }
  },
  render() {
    const els = [];
    if (this.$props.always || !this.loaded) {
      els.push((0, import_vue12.h)(this.$props.as));
    }
    if (!this.loaded) {
      els.push(this.$slots.fallback ? this.$slots.fallback() : null);
    } else if (this.$slots.default) {
      els.push(this.$slots.default());
    }
    return els;
  }
});

// src/index.ts
var config = import_core12.config.extend({});
//# sourceMappingURL=index.js.map
