<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\WelcomeController;
use App\Http\Controllers\AdminController;
use App\Http\Controllers\StudentPortalController;
use App\Http\Controllers\VerificationController;
use App\Http\Controllers\AuthController;
use App\Http\Controllers\StudentCourseController;
use App\Http\Controllers\PartnerController;
use App\Http\Controllers\PartnerAuthController;

Route::get('/', [WelcomeController::class, 'index']);

// Authentication Routes
Route::get('/login', [AuthController::class, 'showLogin'])->name('login');
Route::post('/login', [AuthController::class, 'login']);
Route::post('/logout', [AuthController::class, 'logout'])->name('logout');

// Admin Routes (Protected)
Route::prefix('admin')->name('admin.')->middleware('auth')->group(function () {
    Route::get('/', [AdminController::class, 'index'])->name('index');
    Route::get('/create', [AdminController::class, 'create'])->name('create');
    Route::post('/store', [AdminController::class, 'store'])->name('store');

     // Certificate Credits Management
    Route::get('/credits', [AdminController::class, 'credits'])->name('credits');
    Route::post('/credits/purchase', [AdminController::class, 'purchaseCredits'])->name('credits.purchase');
    
    // Enrollments Management (must be before dynamic routes)
    Route::get('/enrollments', [AdminController::class, 'enrollments'])->name('enrollments');
    Route::get('/certificates', [AdminController::class, 'certificates'])->name('certificates');
    Route::get('/manual-certificates', [AdminController::class, 'manualCertificates'])->name('manual.certificates');
    Route::post('/manual-certificates', [AdminController::class, 'storeManualCertificate'])->name('manual.certificates.store');
    Route::post('/enrollments/{enrollment}/payment', [AdminController::class, 'addPayment'])->name('enrollments.payment');
    Route::post('/enrollments/{enrollment}/certificate', [AdminController::class, 'issueCertificate'])->name('enrollments.certificate');
    Route::get('/enrollments/{enrollment}/records', [AdminController::class, 'viewRecords'])->name('enrollments.records');
    
    Route::get('/{student}', [AdminController::class, 'show'])->name('show');
    Route::get('/{student}/edit', [AdminController::class, 'edit'])->name('edit');
    Route::put('/{student}', [AdminController::class, 'update'])->name('update');
    Route::delete('/{student}', [AdminController::class, 'destroy'])->name('destroy');
    
    // Course Management
    Route::get('/courses/index', [AdminController::class, 'courses'])->name('courses');
    Route::get('/courses/create', [AdminController::class, 'createCourse'])->name('courses.create');
    Route::post('/courses/store', [AdminController::class, 'storeCourse'])->name('courses.store');
    Route::get('/courses/{course}/edit', [AdminController::class, 'editCourse'])->name('courses.edit');
    Route::put('/courses/{course}', [AdminController::class, 'updateCourse'])->name('courses.update');
    Route::delete('/courses/{course}', [AdminController::class, 'destroyCourse'])->name('courses.destroy');
    
    // Student Course Management
    Route::get('/students/{student}/courses', [StudentCourseController::class, 'index'])->name('student.courses');
    Route::post('/students/{student}/courses', [StudentCourseController::class, 'store'])->name('student.courses.store');
    Route::put('/students/{student}/courses/{course}', [StudentCourseController::class, 'update'])->name('student.courses.update');
    Route::delete('/students/{student}/courses/{course}', [StudentCourseController::class, 'destroy'])->name('student.courses.destroy');
    
    // Partner Management
    Route::get('/partners/index', [AdminController::class, 'partners'])->name('partners');
    Route::get('/partners/create', [AdminController::class, 'createPartner'])->name('partners.create');
    Route::post('/partners/store', [AdminController::class, 'storePartner'])->name('partners.store');
    Route::post('/partners/{partner}/reset-code', [AdminController::class, 'resetPartnerCode'])->name('partners.reset.code');
    Route::delete('/partners/{partner}', [AdminController::class, 'destroyPartner'])->name('partners.destroy');
    
    // Center Management
    Route::get('/centers/index', [AdminController::class, 'centers'])->name('centers');
    Route::get('/centers/create', [AdminController::class, 'createCenter'])->name('centers.create');
    Route::post('/centers/store', [AdminController::class, 'storeCenter'])->name('centers.store');
    Route::get('/centers/{center}/edit', [AdminController::class, 'editCenter'])->name('centers.edit');
    Route::put('/centers/{center}', [AdminController::class, 'updateCenter'])->name('centers.update');
});

// Student Portal Routes
Route::prefix('student')->name('student.')->group(function () {
    Route::get('/', [StudentPortalController::class, 'index'])->name('index');
    Route::post('/login', [StudentPortalController::class, 'login'])->name('login');
    Route::get('/profile/{student}', [StudentPortalController::class, 'profile'])->name('profile');
});

// Verification Routes
Route::prefix('verify')->name('verify.')->group(function () {
    Route::get('/', [VerificationController::class, 'index'])->name('index');
    Route::post('/', [VerificationController::class, 'verify'])->name('check');
});

// Partner Routes
Route::prefix('partner')->name('partner.')->group(function () {
    Route::get('/login', [PartnerAuthController::class, 'showLogin'])->name('login');
    Route::post('/login', [PartnerAuthController::class, 'login']);
    Route::post('/logout', [PartnerAuthController::class, 'logout'])->name('logout');
    
    Route::middleware('auth:partner')->group(function () {
        Route::get('/dashboard', [PartnerController::class, 'dashboard'])->name('dashboard');
        Route::get('/students', [PartnerController::class, 'students'])->name('students');
        Route::get('/students/create', [PartnerController::class, 'createStudent'])->name('students.create');
        Route::post('/students/store', [PartnerController::class, 'storeStudent'])->name('students.store');
        Route::get('/courses', [PartnerController::class, 'courses'])->name('courses');
        Route::get('/enrollments', [PartnerController::class, 'enrollments'])->name('enrollments');
        Route::get('/certificates', [PartnerController::class, 'certificates'])->name('certificates');
        Route::get('/manual-certificates', [PartnerController::class, 'manualCertificates'])->name('manual.certificates');
        Route::post('/manual-certificates', [PartnerController::class, 'storeManualCertificate'])->name('manual.certificates.store');
        Route::post('/enrollments/{enrollment}/payment', [PartnerController::class, 'addPayment'])->name('enrollments.payment');
        Route::put('/enrollments/{enrollment}/status', [PartnerController::class, 'updatePaymentStatus'])->name('enrollments.status');
        Route::get('/enrollments/{enrollment}/records', [PartnerController::class, 'viewRecords'])->name('enrollments.records');
    });
});
